//GEMINI-pro DATASET v1.0 Category: Searching algorithm ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    int value;
    char *name;
} entry;

int compare(const void *a, const void *b) {
    const entry *ea = (const entry *)a;
    const entry *eb = (const entry *)b;
    return strcmp(ea->name, eb->name);
}

int binary_search(const entry *arr, int size, const char *key) {
    int low = 0;
    int high = size - 1;
    int mid;

    while (low <= high) {
        mid = (low + high) / 2;
        int cmp = strcmp(arr[mid].name, key);

        if (cmp == 0) {
            return mid;
        } else if (cmp < 0) {
            low = mid + 1;
        } else {
            high = mid - 1;
        }
    }

    return -1;
}

int main() {
    // Create an array of entries
    entry arr[] = {
        {1, "Alice"},
        {2, "Bob"},
        {3, "Carol"},
        {4, "Dave"},
        {5, "Eve"},
    };

    // Sort the array by name
    qsort(arr, sizeof(arr) / sizeof(entry), sizeof(entry), compare);

    // Search for a key
    const char *key = "Bob";
    int index = binary_search(arr, sizeof(arr) / sizeof(entry), key);

    // Print the result
    if (index != -1) {
        printf("Found %s at index %d\n", arr[index].name, index);
    } else {
        printf("Key not found\n");
    }

    return 0;
}