//Code Llama-13B DATASET v1.0 Category: Product Inventory System ; Style: configurable
#include <stdio.h>
    #include <stdlib.h>

    struct Product {
        int id;
        char name[50];
        float price;
    };

    struct Inventory {
        int id;
        int quantity;
    };

    struct Customer {
        int id;
        char name[50];
        float balance;
    };

    struct Order {
        int id;
        int product_id;
        int quantity;
        float total;
    };

    int main() {
        // Declare variables
        int n_products = 10, n_inventory = 10, n_customers = 10, n_orders = 10;
        struct Product products[n_products];
        struct Inventory inventory[n_inventory];
        struct Customer customers[n_customers];
        struct Order orders[n_orders];

        // Initialize products
        for (int i = 0; i < n_products; i++) {
            products[i].id = i;
            strcpy(products[i].name, "Product ");
            products[i].price = 10.0 * (i + 1);
        }

        // Initialize inventory
        for (int i = 0; i < n_inventory; i++) {
            inventory[i].id = i;
            inventory[i].quantity = 100 * (i + 1);
        }

        // Initialize customers
        for (int i = 0; i < n_customers; i++) {
            customers[i].id = i;
            strcpy(customers[i].name, "Customer ");
            customers[i].balance = 1000.0 * (i + 1);
        }

        // Initialize orders
        for (int i = 0; i < n_orders; i++) {
            orders[i].id = i;
            orders[i].product_id = i % n_products;
            orders[i].quantity = 10 * (i + 1);
            orders[i].total = products[orders[i].product_id].price * orders[i].quantity;
        }

        // Display products
        printf("Products:\n");
        for (int i = 0; i < n_products; i++) {
            printf("%d. %s (%.2f)\n", products[i].id, products[i].name, products[i].price);
        }

        // Display inventory
        printf("\nInventory:\n");
        for (int i = 0; i < n_inventory; i++) {
            printf("%d. %d\n", inventory[i].id, inventory[i].quantity);
        }

        // Display customers
        printf("\nCustomers:\n");
        for (int i = 0; i < n_customers; i++) {
            printf("%d. %s (%.2f)\n", customers[i].id, customers[i].name, customers[i].balance);
        }

        // Display orders
        printf("\nOrders:\n");
        for (int i = 0; i < n_orders; i++) {
            printf("%d. %d (%d) (%.2f)\n", orders[i].id, orders[i].product_id, orders[i].quantity, orders[i].total);
        }

        return 0;
    }