//GEMINI-pro DATASET v1.0 Category: Chess engine ; Style: careful
#include <stdio.h>
#include <stdlib.h>

#define BOARD_SIZE 8

typedef enum {
    EMPTY,
    WHITE,
    BLACK
} Piece;

typedef struct {
    Piece piece;
    int x;
    int y;
} Square;

typedef struct {
    Square board[BOARD_SIZE][BOARD_SIZE];
    int active_player;
} Board;

void init_board(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            board->board[i][j].piece = EMPTY;
        }
    }

    // Place the white pieces
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->board[1][i].piece = WHITE;
    }

    // Place the black pieces
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->board[6][i].piece = BLACK;
    }

    // Set the active player to white
    board->active_player = WHITE;
}

void print_board(Board *board) {
    printf("  a b c d e f g h\n");
    for (int i = 0; i < BOARD_SIZE; i++) {
        printf("%d ", i + 1);
        for (int j = 0; j < BOARD_SIZE; j++) {
            switch (board->board[i][j].piece) {
                case EMPTY:
                    printf(" ");
                    break;
                case WHITE:
                    printf("W");
                    break;
                case BLACK:
                    printf("B");
                    break;
            }
        }
        printf("\n");
    }
}

int main() {
    Board board;
    init_board(&board);
    print_board(&board);

    return 0;
}