//LLAMA2-13B DATASET v1.0 Category: Encryption ; Style: accurate
#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <stdlib.h>
#include <time.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 16

void encrypt(char *message, int key[]);
void decrypt(char *message, int key[]);

int main() {
    char message[] = "Hello World!";
    int key[] = {0x12, 0x34, 0x56, 0x78, 0x90, 0xab, 0xcd, 0xef};

    printf("Original message: %s\n", message);
    encrypt(message, key);
    printf("Encrypted message: %s\n", message);

    decrypt(message, key);
    printf("Decrypted message: %s\n", message);

    return 0;
}

void encrypt(char *message, int key[]) {
    int i, j, k;
    char temp;

    for (i = 0; i < strlen(message); i++) {
        j = (i * 3) % strlen(key);
        k = j % strlen(message);
        temp = message[i];

        message[i] = (char)((temp + key[j]) % 256);
    }
}

void decrypt(char *message, int key[]) {
    int i, j, k;
    char temp;

    for (i = 0; i < strlen(message); i++) {
        j = (i * 3) % strlen(key);
        k = j % strlen(message);
        temp = message[i];

        message[i] = (char)((temp - key[j]) % 256);
    }
}