//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_USERS 10
#define MAX_TRANSACTIONS 100

typedef struct {
    char name[20];
    int balance;
} User;

typedef struct {
    char description[50];
    int amount;
    time_t date;
    char user[20];
} Transaction;

User users[MAX_USERS];
Transaction transactions[MAX_TRANSACTIONS];
int num_users = 0;
int num_transactions = 0;

void add_user(char* name) {
    strcpy(users[num_users].name, name);
    users[num_users].balance = 0;
    num_users++;
}

int find_user(char* name) {
    for(int i=0; i<num_users; i++) {
        if(strcmp(users[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

void add_transaction(char* description, int amount, char* user) {
    strcpy(transactions[num_transactions].description, description);
    transactions[num_transactions].amount = amount;
    strcpy(transactions[num_transactions].user, user);
    time(&transactions[num_transactions].date);
    num_transactions++;
}

void display_users() {
    printf("Users:\n");
    for(int i=0; i<num_users; i++) {
        printf("%s - Balance: %d\n", users[i].name, users[i].balance);
    }
}

void display_transactions(int user_id) {
    printf("Transactions for %s:\n", users[user_id].name);
    for(int i=0; i<num_transactions; i++) {
        if(strcmp(transactions[i].user, users[user_id].name) == 0) {
            printf("%s - %d - %s\n", transactions[i].description, transactions[i].amount, ctime(&transactions[i].date));
        }
    }
}

int main() {
    add_user("Alice");
    add_user("Bob");
    add_user("Charlie");

    add_transaction("Lunch", 10, "Alice");
    add_transaction("Coffee", 5, "Bob");
    add_transaction("Dinner", 20, "Charlie");

    display_users();

    int user_id = find_user("Alice");
    display_transactions(user_id);

    return 0;
}