//Falcon2-11B DATASET v1.0 Category: Database simulation ; Style: secure
#include <stdio.h>
#include <string.h>

#define MAX_RECORDS 10

typedef struct {
    char name[50];
    int age;
} Record;

Record records[MAX_RECORDS];
int record_count = 0;

void create_record(const char* name, int age) {
    Record new_record;
    strcpy(new_record.name, name);
    new_record.age = age;
    records[record_count++] = new_record;
}

void search_record(const char* name) {
    for (int i = 0; i < record_count; i++) {
        if (strcmp(records[i].name, name) == 0) {
            printf("Found record: %s, %d\n", records[i].name, records[i].age);
            return;
        }
    }
    printf("Record not found\n");
}

int main() {
    create_record("John", 25);
    create_record("Jane", 22);
    create_record("Alice", 30);

    printf("Searching for 'Jane':\n");
    search_record("Jane");

    printf("Searching for 'Alice':\n");
    search_record("Alice");

    printf("Searching for 'Bob':\n");
    search_record("Bob");

    printf("Searching for 'Alice':\n");
    search_record("Alice");

    printf("Searching for 'John':\n");
    search_record("John");

    printf("Searching for 'Jane':\n");
    search_record("Jane");

    printf("Searching for 'Bob':\n");
    search_record("Bob");

    return 0;
}