//Falcon-180B DATASET v1.0 Category: System process viewer ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    int id;
    char name[20];
    int state;
} process;

process processes[10];
int num_processes = 0;

void add_process(int id, char* name, int state) {
    if (num_processes >= 10) {
        printf("Error: maximum number of processes reached\n");
        return;
    }
    processes[num_processes].id = id;
    strcpy(processes[num_processes].name, name);
    processes[num_processes].state = state;
    num_processes++;
}

void remove_process(int id) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].id == id) {
            memmove(&processes[i], &processes[i+1], sizeof(process) * (num_processes - i - 1));
            num_processes--;
            return;
        }
    }
    printf("Error: process not found\n");
}

void display_processes() {
    int i;
    for (i = 0; i < num_processes; i++) {
        printf("%d - %s - %d\n", processes[i].id, processes[i].name, processes[i].state);
    }
}

int main() {
    add_process(1, "process1", 0);
    add_process(2, "process2", 1);
    display_processes();
    remove_process(1);
    display_processes();
    return 0;
}