//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 16

unsigned char key[KEY_SIZE] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};
unsigned char block[BLOCK_SIZE] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};

void encrypt_block(unsigned char *block) {
  // Add round key
  for (int i = 0; i < BLOCK_SIZE; i++) {
    block[i] ^= key[i];
  }

  // Shift rows
  unsigned char tmp[BLOCK_SIZE];
  for (int i = 0; i < BLOCK_SIZE; i++) {
    tmp[i] = block[(i + 1) % BLOCK_SIZE];
  }
  memcpy(block, tmp, BLOCK_SIZE);

  // Mix columns
  for (int i = 0; i < BLOCK_SIZE; i++) {
    unsigned char t1 = block[i];
    unsigned char t2 = block[(i + 4) % BLOCK_SIZE];
    unsigned char t3 = block[(i + 8) % BLOCK_SIZE];
    unsigned char t4 = block[(i + 12) % BLOCK_SIZE];
    block[i] = t1 ^ t2 ^ t3 ^ t4;
    block[(i + 4) % BLOCK_SIZE] = t1 ^ t2 ^ t3 ^ t4;
    block[(i + 8) % BLOCK_SIZE] = t1 ^ t2 ^ t3 ^ t4;
    block[(i + 12) % BLOCK_SIZE] = t1 ^ t2 ^ t3 ^ t4;
  }
}

void decrypt_block(unsigned char *block) {
  // Inverse mix columns
  for (int i = 0; i < BLOCK_SIZE; i++) {
    unsigned char t1 = block[i];
    unsigned char t2 = block[(i + 4) % BLOCK_SIZE];
    unsigned char t3 = block[(i + 8) % BLOCK_SIZE];
    unsigned char t4 = block[(i + 12) % BLOCK_SIZE];
    block[i] = t4 ^ t3 ^ t2 ^ t1;
    block[(i + 4) % BLOCK_SIZE] = t4 ^ t3 ^ t2 ^ t1;
    block[(i + 8) % BLOCK_SIZE] = t4 ^ t3 ^ t2 ^ t1;
    block[(i + 12) % BLOCK_SIZE] = t4 ^ t3 ^ t2 ^ t1;
  }

  // Inverse shift rows
  unsigned char tmp[BLOCK_SIZE];
  for (int i = 0; i < BLOCK_SIZE; i++) {
    tmp[i] = block[(i + 3) % BLOCK_SIZE];
  }
  memcpy(block, tmp, BLOCK_SIZE);

  // Add round key
  for (int i = 0; i < BLOCK_SIZE; i++) {
    block[i] ^= key[i];
  }
}

int main() {
  // Encrypt block
  encrypt_block(block);

  // Decrypt block
  decrypt_block(block);

  // Print plaintext
  for (int i = 0; i < BLOCK_SIZE; i++) {
    printf("%02x", block[i]);
  }
  printf("\n");

  return 0;
}