//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: statistical
/* Building a HTTP Client in C: A Statistical Symphony */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

typedef struct {
    size_t size;
    char *data;
} ResponseData;

size_t write_data(void *buffer, size_t size, size_t nmemb, void *userp) {
    ResponseData *response = (ResponseData *)userp;
    size_t realsize = size * nmemb;

    response->data = realloc(response->data, response->size + realsize + 1);
    if (response->data == NULL) {
        return 0;
    }

    memcpy(&(response->data[response->size]), buffer, realsize);
    response->size += realsize;
    response->data[response->size] = '\0';

    return realsize;
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <URL>\n", argv[0]);
        return EXIT_FAILURE;
    }

    CURL *curl = curl_easy_init();
    if (curl == NULL) {
        fprintf(stderr, "Error: curl_easy_init() failed\n");
        return EXIT_FAILURE;
    }

    curl_easy_setopt(curl, CURLOPT_URL, argv[1]);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);

    ResponseData response = { 0, NULL };
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response);

    CURLcode res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "Error: curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        free(response.data);
        curl_easy_cleanup(curl);
        return EXIT_FAILURE;
    }

    printf("HTTP Response:\n%s", response.data);
    free(response.data);

    curl_easy_cleanup(curl);
    return EXIT_SUCCESS;
}