//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>

// Structure to represent an activity
typedef struct {
    int start;
    int end;
} Activity;

// Function to compare two activities based on their end times
int activityComparator(const void* a, const void* b) {
    Activity* activityA = (Activity*)a;
    Activity* activityB = (Activity*)b;
    return activityA->end - activityB->end;
}

// Function to select the maximum number of activities
void selectActivities(Activity arr[], int n) {
    // Sort activities based on their end times
    qsort(arr, n, sizeof(Activity), activityComparator);

    printf("The selected activities are:\n");

    // The first activity is always selected
    int lastEndTime = arr[0].end;
    printf("Activity with start time: %d and end time: %d\n", arr[0].start, arr[0].end);

    // Iterate through the sorted activities
    for (int i = 1; i < n; i++) {
        // If the start time of this activity is greater than or equal to
        // the end time of the last selected activity, select it
        if (arr[i].start >= lastEndTime) {
            printf("Activity with start time: %d and end time: %d\n", arr[i].start, arr[i].end);
            lastEndTime = arr[i].end; // Update the last end time
        }
    }
}

// Main function to drive the program
int main() {
    // Example array of activities with their respective start and end times
    Activity activities[] = {
        {0, 6}, {5, 7}, {1, 4}, {3, 5}, {5, 9}, {8, 9}, {2, 3}
    };
    int n = sizeof(activities) / sizeof(activities[0]); // Total number of activities

    // Call the function to select and print the activities
    selectActivities(activities, n);

    return 0; // Indicating successful completion of the program
}