//MISTRAL-7B DATASET v1.0 Category: Word Count Tool ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define MAX_BUF_SIZE 1024
#define WORD_DELIM " \t\r\n\f,"

int main(int argc, char *argv[]) {
    int fd;
    char buf[MAX_BUF_SIZE];
    int num_words = 0;

    if (argc != 2) {
        printf("Usage: %s <filename>\n", argv[0]);
        return 1;
    }

    fd = open(argv[1], O_RDONLY);
    if (fd < 0) {
        perror("Error opening file");
        return 1;
    }

    struct stat file_stat;
    if (fstat(fd, &file_stat) < 0) {
        perror("Error getting file size");
        close(fd);
        return 1;
    }

    ssize_t num_read;
    for (ssize_t offset = 0; offset < file_stat.st_size; offset += num_read) {
        num_read = read(fd, buf, sizeof(buf));
        if (num_read <= 0) {
            break;
        }

        char *word_start = buf;
        for (char *word_end = buf; *word_end; word_end++) {
            if (strchr(WORD_DELIM, *word_end)) {
                num_words++;
                if (word_end > word_start && word_start != buf) {
                    putchar('\n');
                    putchar(' ');
                    fwrite(word_start, word_end - word_start, 1, stdout);
                    num_words++;
                }
                word_start = word_end + 1;
            }
        }

        if (word_start < buf + sizeof(buf) && *(word_start) != '\0') {
            num_words++;
            putchar('\n');
            putchar(' ');
            fwrite(word_start, sizeof(char), strlen(word_start), stdout);
            num_words++;
        }
    }

    close(fd);
    printf("Number of words: %d\n", num_words);
    return 0;
}