//GEMINI-pro DATASET v1.0 Category: Searching algorithm ; Style: romantic
#include <stdio.h>
#include <stdlib.h>

// Structure to represent a person
typedef struct {
    char name[50];
    int age;
    char gender;
} Person;

// Function to compare two persons
int comparePersons(const void *a, const void *b) {
    Person *person1 = (Person *)a;
    Person *person2 = (Person *)b;

    return strcmp(person1->name, person2->name);
}

// Function to search for a person in an array
Person *searchPerson(Person *array, int size, char *name) {
    // Perform binary search
    int low = 0;
    int high = size - 1;
    while (low <= high) {
        int mid = (low + high) / 2;

        if (strcmp(array[mid].name, name) == 0) {
            return &array[mid];
        } else if (strcmp(array[mid].name, name) < 0) {
            low = mid + 1;
        } else {
            high = mid - 1;
        }
    }

    // Person not found
    return NULL;
}

// Main function
int main() {
    // Create an array of persons
    Person persons[] = {
        {"Alice", 20, 'F'},
        {"Bob", 25, 'M'},
        {"Carol", 30, 'F'},
        {"David", 35, 'M'},
        {"Eve", 40, 'F'},
    };

    // Sort the array of persons by name
    qsort(persons, 5, sizeof(Person), comparePersons);

    // Search for a person by name
    char *name = "Carol";
    Person *result = searchPerson(persons, 5, name);

    // Print the result
    if (result != NULL) {
        printf("Person found:\n");
        printf("Name: %s\n", result->name);
        printf("Age: %d\n", result->age);
        printf("Gender: %c\n", result->gender);
    } else {
        printf("Person not found.\n");
    }

    return 0;
}