//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: careful
#include <stdio.h>
#include <stdlib.h>

// Define a structure to store hotel room information
struct room {
    int number;
    char type;
    int availability;
    float rate;
};

// Define a function to check room availability
int check_availability(struct room *room) {
    return room->availability;
}

// Define a function to book a room
void book_room(struct room *room) {
    room->availability = 0;
}

// Define a function to calculate the total cost of a stay
float calculate_cost(struct room *room, int days) {
    return room->rate * days;
}

// Create an array of rooms
struct room rooms[] = {
    {101, 'A', 1, 500.0},
    {102, 'B', 1, 600.0},
    {103, 'C', 1, 700.0},
    {104, 'A', 1, 500.0},
    {105, 'B', 1, 600.0}
};

int main() {
    // Display the available rooms
    for (int i = 0; i < 5; i++) {
        printf("Room number: %d, Type: %c, Availability: %d, Rate: %.2f\n", rooms[i].number, rooms[i].type, check_availability(&rooms[i]), rooms[i].rate);
    }

    // Book a room
    book_room(&rooms[0]);

    // Display the updated available rooms
    for (int i = 0; i < 5; i++) {
        printf("Room number: %d, Type: %c, Availability: %d, Rate: %.2f\n", rooms[i].number, rooms[i].type, check_availability(&rooms[i]), rooms[i].rate);
    }

    // Calculate the total cost of a stay
    float total_cost = calculate_cost(&rooms[0], 3);

    // Display the total cost
    printf("Total cost: %.2f\n", total_cost);

    return 0;
}