//GEMINI-pro DATASET v1.0 Category: Pattern printing ; Style: real-life
#include <stdio.h>

// A structure to represent a point in a 2D plane
typedef struct {
    int x;
    int y;
} Point;

// A function to print a rectangle of asterisks (*)
void print_rectangle(Point top_left, int width, int height) {
    for (int i = top_left.y; i < top_left.y + height; i++) {
        for (int j = top_left.x; j < top_left.x + width; j++) {
            printf("*");
        }
        printf("\n");
    }
}

// A function to print a triangle of asterisks (*)
void print_triangle(Point top, int height) {
    for (int i = 0; i < height; i++) {
        for (int j = 0; j <= i; j++) {
            printf("*");
        }
        printf("\n");
    }
}

// A function to print a diamond of asterisks (*)
void print_diamond(Point center, int size) {
    // Print the top half of the diamond
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size - i - 1; j++) {
            printf(" ");
        }
        for (int j = 0; j < 2 * i + 1; j++) {
            printf("*");
        }
        printf("\n");
    }

    // Print the bottom half of the diamond
    for (int i = 1; i < size; i++) {
        for (int j = 0; j < i; j++) {
            printf(" ");
        }
        for (int j = 0; j < 2 * (size - i) - 1; j++) {
            printf("*");
        }
        printf("\n");
    }
}

// A function to print a heart of asterisks (*)
void print_heart(Point center, int size) {
    // Print the top half of the heart
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size - i - 1; j++) {
            printf(" ");
        }
        for (int j = 0; j < 2 * i + 1; j++) {
            printf("*");
        }
        printf("\n");
    }

    // Print the bottom half of the heart
    for (int i = 1; i < size; i++) {
        for (int j = 0; j < i; j++) {
            printf(" ");
        }
        for (int j = 0; j < 2 * (size - i) - 1; j++) {
            printf("*");
        }
        printf("\n");
    }

    // Print the bottom curve of the heart
    for (int i = 0; i < size / 2; i++) {
        for (int j = 0; j < size - i - 1; j++) {
            printf(" ");
        }
        for (int j = 0; j < 2 * i + 1; j++) {
            printf("*");
        }
        printf("\n");
    }
}

int main() {
    // Print a rectangle
    print_rectangle((Point){0, 0}, 10, 5);
    printf("\n");

    // Print a triangle
    print_triangle((Point){0, 0}, 10);
    printf("\n");

    // Print a diamond
    print_diamond((Point){0, 0}, 10);
    printf("\n");

    // Print a heart
    print_heart((Point){0, 0}, 10);
    printf("\n");

    return 0;
}