//LLAMA2-13B DATASET v1.0 Category: Table Game ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PLAYERS 2
#define MAX_GUESSES 3

// Structure to hold player's guess and outcome
typedef struct {
    char guess;    // Player's guess (rock, paper, or scissors)
    char outcome;  // Outcome of the game (win, loss, or draw)
} game_t;

// Function to generate a random guess for player 1
void generate_guess1(game_t *g1) {
    int r = rand() % 3;  // Generate a random number between 0 and 2
    g1->guess = (r == 0) ? 'R' : (r == 1) ? 'P' : 'S';  // Assign the guess based on the random number
}

// Function to generate a random guess for player 2
void generate_guess2(game_t *g2) {
    int r = rand() % 3;
    g2->guess = (r == 0) ? 'R' : (r == 1) ? 'P' : 'S';
}

// Function to determine the winner of the game
void determine_winner(game_t *g1, game_t *g2) {
    if (g1->guess == g2->guess) {
        // Draw
        g1->outcome = 'D';
        g2->outcome = 'D';
    } else if (g1->guess == 'R' && g2->guess == 'P') {
        // Rock beats Scissors
        g1->outcome = 'W';
        g2->outcome = 'L';
    } else if (g1->guess == 'R' && g2->guess == 'S') {
        // Rock beats Paper
        g1->outcome = 'W';
        g2->outcome = 'L';
    } else if (g1->guess == 'P' && g2->guess == 'S') {
        // Paper beats Scissors
        g1->outcome = 'L';
        g2->outcome = 'W';
    } else {
        // Scissors beats Rock
        g1->outcome = 'L';
        g2->outcome = 'W';
    }
}

int main() {
    // Initialize game variables
    game_t g1, g2;
    generate_guess1(&g1);
    generate_guess2(&g2);

    // Determine the winner of the game
    determine_winner(&g1, &g2);

    // Print the outcome of the game
    printf("Game Over! %c beats %c\n", g1.outcome, g2.outcome);

    return 0;
}