//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of accounts that can be created
#define MAX_ACCOUNTS 1000

// Define the structure of a bank account
typedef struct {
    int accountNumber;
    char name[50];
    double balance;
} Account;

// Define the global array of bank accounts
Account accounts[MAX_ACCOUNTS];
int numAccounts = 0;

// Function to create a new bank account
void createAccount(char* name, double initialBalance) {
    // Find an empty slot in the accounts array
    int i;
    for (i = 0; i < numAccounts; i++) {
        if (strcmp(accounts[i].name, "") == 0) {
            // Set the account details
            accounts[i].accountNumber = numAccounts;
            strcpy(accounts[i].name, name);
            accounts[i].balance = initialBalance;
            // Increment the number of accounts
            numAccounts++;
            return;
        }
    }
}

// Function to deposit money into an account
void deposit(int accountNumber, double amount) {
    // Find the account with the given account number
    int i;
    for (i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == accountNumber) {
            // Update the account balance
            accounts[i].balance += amount;
            printf("Deposit of $%.2f made to account #%d\n", amount, accountNumber);
            return;
        }
    }
    // Account not found
    printf("Account not found\n");
}

// Function to withdraw money from an account
void withdraw(int accountNumber, double amount) {
    // Find the account with the given account number
    int i;
    for (i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == accountNumber) {
            // Check if there is enough balance to make the withdrawal
            if (accounts[i].balance >= amount) {
                // Update the account balance
                accounts[i].balance -= amount;
                printf("Withdrawal of $%.2f made from account #%d\n", amount, accountNumber);
                return;
            } else {
                // Insufficient balance
                printf("Insufficient balance\n");
                return;
            }
        }
    }
    // Account not found
    printf("Account not found\n");
}

// Function to print the details of all accounts
void printAccounts() {
    printf("Account Number\tName\t\tBalance\n");
    int i;
    for (i = 0; i < numAccounts; i++) {
        if (strcmp(accounts[i].name, "")!= 0) {
            printf("%d\t%s\t\t$%.2f\n", accounts[i].accountNumber, accounts[i].name, accounts[i].balance);
        }
    }
}

int main() {
    createAccount("John Doe", 1000.00);
    createAccount("Jane Doe", 2000.00);
    deposit(1, 500.00);
    withdraw(2, 1000.00);
    printAccounts();
    return 0;
}