//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EVENTS 1000

typedef struct {
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
} Time;

typedef struct {
    Time arrival_time;
    Time departure_time;
    char *description;
} Event;

Time current_time = {2022, 1, 1, 0, 0, 0};
int num_events = 0;
Event events[MAX_EVENTS];

void add_event(Event *event) {
    if (num_events >= MAX_EVENTS) {
        printf("Error: Maximum number of events reached.\n");
        exit(1);
    }
    events[num_events++] = *event;
}

void print_events() {
    for (int i = 0; i < num_events; i++) {
        printf("%s: %04d-%02d-%02d %02d:%02d:%02d -> %04d-%02d-%02d %02d:%02d:%02d\n", events[i].description, events[i].arrival_time.year, events[i].arrival_time.month, events[i].arrival_time.day, events[i].arrival_time.hour, events[i].arrival_time.minute, events[i].arrival_time.second, events[i].departure_time.year, events[i].departure_time.month, events[i].departure_time.day, events[i].departure_time.hour, events[i].departure_time.minute, events[i].departure_time.second);
    }
}

void time_travel(Time target_time) {
    current_time = target_time;
    printf("Time travel initiated. New time: %04d-%02d-%02d %02d:%02d:%02d\n", current_time.year, current_time.month, current_time.day, current_time.hour, current_time.minute, current_time.second);
}

void check_events() {
    for (int i = 0; i < num_events; i++) {
        if (current_time.year == events[i].arrival_time.year && current_time.month == events[i].arrival_time.month && current_time.day == events[i].arrival_time.day && current_time.hour == events[i].arrival_time.hour && current_time.minute == events[i].arrival_time.minute && current_time.second == events[i].arrival_time.second) {
            printf("Event detected: %s\n", events[i].description);
        }
    }
}

int main() {
    Event new_year = {2022, 1, 1, 0, 0, 0, "New Year's Day"};
    add_event(&new_year);

    Event independence_day = {2022, 7, 4, 0, 0, 0, "Independence Day"};
    add_event(&independence_day);

    Event christmas = {2022, 12, 25, 0, 0, 0, "Christmas Day"};
    add_event(&christmas);

    time_travel(new_year.arrival_time);
    check_events();

    time_travel(independence_day.arrival_time);
    check_events();

    time_travel(christmas.arrival_time);
    check_events();

    return 0;
}