//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 10

typedef struct Ghost {
    char name[20];
    int room_number;
    int presence;
} Ghost;

Ghost ghosts[MAX_GHOSTS] = {
    {"Mr. Bartholomew", 1, 1},
    {"Ms. Amelia", 2, 1},
    {"Mr. Jones", 3, 0},
    {"Mrs. Smith", 4, 1},
    {"Mr. Brown", 5, 0},
    {"Ms. Johnson", 6, 1},
    {"Mr. Miller", 7, 0},
    {"Mrs. White", 8, 1},
    {"Mr. Gray", 9, 0},
    {"Ms. Brown", 10, 1}
};

void initialize_ghosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        ghosts[i].presence = 0;
    }
}

void move_ghosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i].presence) {
            ghosts[i].room_number = rand() % MAX_GHOSTS + 1;
        }
    }
}

void check_ghosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i].presence) {
            printf("Ghost %s is in room %d.\n", ghosts[i].name, ghosts[i].room_number);
        }
    }
}

int main() {
    initialize_ghosts();
    move_ghosts();
    check_ghosts();

    return 0;
}