//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_WEATHER 5

// Structure to represent weather conditions
typedef struct {
    int id;
    char condition[20];
    float temperature;
    float wind_speed;
} Weather;

// Function prototypes
void generate_weather(Weather *weather);
void print_weather(const Weather *weather);

int main() {
    srand(time(NULL)); // Seed random number generator

    Weather weather[NUM_WEATHER];

    // Generate weather conditions for each element in the array
    for (int i = 0; i < NUM_WEATHER; i++) {
        generate_weather(&weather[i]);
    }

    // Print each weather condition
    for (int i = 0; i < NUM_WEATHER; i++) {
        print_weather(&weather[i]);
        printf("\n");
    }

    return 0;
}

// Function to generate random weather conditions
void generate_weather(Weather *weather) {
    // Assign random ID and condition
    weather->id = rand() % 3 + 1;
    switch (weather->id) {
        case 1: strcpy(weather->condition, "Sunny"); break;
        case 2: strcpy(weather->condition, "Rainy"); break;
        case 3: strcpy(weather->condition, "Cloudy"); break;
    }

    // Generate random temperature and wind speed
    weather->temperature = rand() % 20 + 10;
    weather->wind_speed = (rand() % 10 + 5.0) / 5.0;
}

// Function to print weather conditions
void print_weather(const Weather *weather) {
    printf("ID: %d\n", weather->id);
    printf("Condition: %s\n", weather->condition);
    printf("Temperature: %.1f degrees Celsius\n", weather->temperature);
    printf("Wind Speed: %.1f meters per second\n", weather->wind_speed);
}