//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define DAYS_IN_WEEK 7
#define TEMP_MIN -10
#define TEMP_MAX 35

// Using an enum to represent the weather conditions
typedef enum {
    SUNNY,
    RAINY,
    CLOUDY,
    SNOWY,
    WINDY,
    WEATHER_COUNT // This helps us to easily manage the number of weather types
} WeatherCondition;

// Function to convert WeatherCondition enum to string
const char* weatherToString(WeatherCondition condition) {
    switch (condition) {
        case SUNNY: return "Sunny";
        case RAINY: return "Rainy";
        case CLOUDY: return "Cloudy";
        case SNOWY: return "Snowy";
        case WINDY: return "Windy";
        default: return "Unknown";
    }
}

// Weather data structure
typedef struct {
    WeatherCondition condition;
    int temperature;
} DailyWeather;

// Function to generate random weather data
DailyWeather generateRandomWeather() {
    DailyWeather weather;
    weather.condition = rand() % WEATHER_COUNT;
    weather.temperature = (rand() % (TEMP_MAX - TEMP_MIN + 1)) + TEMP_MIN;
    return weather;
}

// Function to display the weekly weather report
void displayWeatherReport(DailyWeather weekWeather[DAYS_IN_WEEK]) {
    printf("Weekly Weather Report:\n");
    printf("-------------------------------\n");
    for (int i = 0; i < DAYS_IN_WEEK; i++) {
        printf("Day %d: %s, Temperature: %d°C\n", i + 1,
               weatherToString(weekWeather[i].condition), weekWeather[i].temperature);
    }
    printf("-------------------------------\n");
}

int main() {
    srand(time(0)); // Seed the random number generator
    DailyWeather weekWeather[DAYS_IN_WEEK];

    // Generate weather for each day of the week
    for (int i = 0; i < DAYS_IN_WEEK; i++) {
        weekWeather[i] = generateRandomWeather();
    }

    // Display the weather report
    displayWeatherReport(weekWeather);

    return 0;
}