//GPT-4o-mini DATASET v1.0 Category: Bitwise operations ; Style: careful
#include <stdio.h>
#include <stdint.h>

// Function to perform bitwise AND operation
uint32_t bitwise_and(uint32_t a, uint32_t b) {
    return a & b;
}

// Function to perform bitwise OR operation
uint32_t bitwise_or(uint32_t a, uint32_t b) {
    return a | b;
}

// Function to perform bitwise XOR operation
uint32_t bitwise_xor(uint32_t a, uint32_t b) {
    return a ^ b;
}

// Function to perform bitwise NOT operation
uint32_t bitwise_not(uint32_t a) {
    return ~a;
}

// Function to perform left shift operation
uint32_t left_shift(uint32_t a, int shift) {
    return a << shift;
}

// Function to perform right shift operation
uint32_t right_shift(uint32_t a, int shift) {
    return a >> shift;
}

// Function to count the number of set bits (1s) in a number
int count_set_bits(uint32_t n) {
    int count = 0;
    while (n) {
        count += n & 1; // Increment if the last bit is set
        n >>= 1; // Right shift to check the next bit
    }
    return count;
}

// Function to display the binary representation of a number
void print_binary(uint32_t n) {
    for (int i = 31; i >= 0; i--) {
        printf("%d", (n >> i) & 1);
    }
    printf("\n");
}

// Function to demonstrate various bitwise operations
void demonstrate_bitwise_operations() {
    uint32_t a = 29; // 00000000000000000000000000011101
    uint32_t b = 15; // 00000000000000000000000000001111

    printf("Value of a: %u\n", a);
    printf("Value of b: %u\n", b);

    printf("\nBitwise AND (a & b): %u\n", bitwise_and(a, b));
    printf("Binary representation: ");
    print_binary(bitwise_and(a, b));
    
    printf("\nBitwise OR (a | b): %u\n", bitwise_or(a, b));
    printf("Binary representation: ");
    print_binary(bitwise_or(a, b));
    
    printf("\nBitwise XOR (a ^ b): %u\n", bitwise_xor(a, b));
    printf("Binary representation: ");
    print_binary(bitwise_xor(a, b));
    
    printf("\nBitwise NOT (~a): %u\n", bitwise_not(a));
    printf("Binary representation: ");
    print_binary(bitwise_not(a));
    
    int shift = 2;
    printf("\nLeft shift (a << %d): %u\n", shift, left_shift(a, shift));
    printf("Binary representation: ");
    print_binary(left_shift(a, shift));
    
    printf("\nRight shift (a >> %d): %u\n", shift, right_shift(a, shift));
    printf("Binary representation: ");
    print_binary(right_shift(a, shift));
    
    printf("\nNumber of set bits in a (%u): %d\n", a, count_set_bits(a));
    printf("Number of set bits in b (%u): %d\n", b, count_set_bits(b));
}

// Main function
int main() {
    printf("Demonstration of Bitwise Operations in C\n");
    printf("=========================================\n");
    
    demonstrate_bitwise_operations();

    return 0;
}