//Falcon-180B DATASET v1.0 Category: Smart home automation ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

#define I2C_SLAVE 0x70
#define I2C_DEVICE "/dev/i2c-0"

int main() {
    int file;
    char *dev_name = I2C_DEVICE;
    int addr = I2C_SLAVE;
    int res;

    // Open the device
    file = open(dev_name, O_RDWR);
    if (file < 0) {
        printf("Error: Can't open device\n");
        exit(1);
    }

    // Set the slave address
    res = ioctl(file, I2C_SLAVE, addr);
    if (res < 0) {
        printf("Error: Can't set slave address\n");
        exit(1);
    }

    // Write data to the device
    char data[] = "Hello, world!";
    int len = strlen(data);
    res = write(file, data, len);
    if (res!= len) {
        printf("Error: Can't write data\n");
        exit(1);
    }

    // Read data from the device
    char buf[len];
    res = read(file, buf, len);
    if (res!= len) {
        printf("Error: Can't read data\n");
        exit(1);
    }

    // Close the device
    res = close(file);
    if (res < 0) {
        printf("Error: Can't close device\n");
        exit(1);
    }

    printf("Data written and read successfully!\n");

    return 0;
}