//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSORS 4
#define MAX_QUEUE_SIZE 5

typedef struct Process
{
    int process_id;
    char name[20];
    int arrival_time;
    int service_time;
    int remaining_time;
    int queue_position;
} Process;

Process processes[MAX_PROCESSORS];

void initialize_processes()
{
    for (int i = 0; i < MAX_PROCESSORS; i++)
    {
        processes[i].process_id = i + 1;
        processes[i].arrival_time = rand() % MAX_QUEUE_SIZE;
        processes[i].service_time = rand() % MAX_QUEUE_SIZE;
        processes[i].remaining_time = processes[i].service_time;
        processes[i].queue_position = -1;
    }
}

void simulate_cpu_scheduling()
{
    int current_time = 0;
    int quantum = 0;

    while (!all_processes_completed())
    {
        for (int i = 0; i < MAX_PROCESSORS; i++)
        {
            if (processes[i].queue_position != -1 && processes[i].remaining_time > 0)
            {
                processes[i].remaining_time--;
                quantum++;

                if (processes[i].remaining_time == 0)
                {
                    processes[i].queue_position = -1;
                    printf("Process %d completed.\n", processes[i].process_id);
                }
            }
        }

        current_time++;
    }

    printf("Total time: %d\n", current_time);
    printf("Total quantum: %d\n", quantum);
}

int all_processes_completed()
{
    for (int i = 0; i < MAX_PROCESSORS; i++)
    {
        if (processes[i].queue_position != -1)
        {
            return 0;
        }
    }

    return 1;
}

int main()
{
    initialize_processes();
    simulate_cpu_scheduling();

    return 0;
}