//Falcon-180B DATASET v1.0 Category: Wireless Network Scanner ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>

#define BUF_SIZE 1024
#define MAX_RESULTS 10

struct sockaddr_in server_addr;

void print_results(char *ip, int port) {
    printf("IP: %s\n", ip);
    printf("Port: %d\n", port);
    printf("\n");
}

int main(int argc, char *argv[]) {
    if (argc < 2) {
        printf("Usage: %s <IP address>\n", argv[0]);
        return 1;
    }

    char *ip = argv[1];
    int port = 80;

    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        printf("Error creating socket\n");
        return 1;
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);

    if (inet_pton(AF_INET, ip, &server_addr.sin_addr) <= 0) {
        printf("Invalid IP address\n");
        close(sock);
        return 1;
    }

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Connection failed\n");
        close(sock);
        return 1;
    }

    printf("Connected to %s:%d\n", inet_ntoa(server_addr.sin_addr), port);
    close(sock);

    return 0;
}