//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char content[100];
} File;

int num_files = 0;
File files[MAX_FILES];

void create_file(char *name) {
    if (num_files >= MAX_FILES) {
        printf("Error: cannot create more files.\n");
        return;
    }
    strcpy(files[num_files].name, name);
    num_files++;
}

void delete_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(&files[i], 0, sizeof(File));
            num_files--;
            return;
        }
    }
    printf("Error: file not found.\n");
}

void write_file(char *name, char *content) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);
            return;
        }
    }
    printf("Error: file not found.\n");
}

void read_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("%s\n", files[i].content);
            return;
        }
    }
    printf("Error: file not found.\n");
}

int main() {
    create_file("test.txt");
    write_file("test.txt", "Hello, world!");
    read_file("test.txt");
    delete_file("test.txt");
    return 0;
}