//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12
#define NUM_SPECIAL_CHARS 4

const char lowercase[] = "abcdefghijklmnopqrstuvwxyz";
const char uppercase[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char digits[] = "0123456789";
const char specialChars[] = "!@#$%^&*()_-+=<>,.?/";

void generatePassword(char* password) {
    // Seed the random number generator
    srand((unsigned int)time(0));
    
    // Ensure inclusion of at least one character from each category
    password[0] = lowercase[rand() % strlen(lowercase)];
    password[1] = uppercase[rand() % strlen(uppercase)];
    password[2] = digits[rand() % strlen(digits)];
    for (int i = 3; i < NUM_SPECIAL_CHARS + 3; i++) {
        password[i] = specialChars[rand() % strlen(specialChars)];
    }

    // Fill the remaining characters with random selections
    for (int i = NUM_SPECIAL_CHARS + 3; i < PASSWORD_LENGTH; i++) {
        int category = rand() % 4;
        switch (category) {
            case 0:
                password[i] = lowercase[rand() % strlen(lowercase)];
                break;
            case 1:
                password[i] = uppercase[rand() % strlen(uppercase)];
                break;
            case 2:
                password[i] = digits[rand() % strlen(digits)];
                break;
            case 3:
                password[i] = specialChars[rand() % strlen(specialChars)];
                break;
            default:
                break;
        }
    }
    
    // Shuffle the password to avoid predictable patterns
    for (int i = PASSWORD_LENGTH - 1; i > 0; i--) {
        int j = rand() % (i + 1);
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    password[PASSWORD_LENGTH] = '\0'; // Null-terminate the string
}

void printInstructions() {
    printf("===================================\n");
    printf("  Secure Password Generator\n");
    printf("===================================\n");
    printf("This program generates a secure random password of length %d\n", PASSWORD_LENGTH);
    printf("The password includes:\n");
    printf("- At least 1 lowercase letter\n");
    printf("- At least 1 uppercase letter\n");
    printf("- At least 1 digit\n");
    printf("- At least %d special characters\n", NUM_SPECIAL_CHARS);
    printf("===================================\n");
}

int main() {
    char password[PASSWORD_LENGTH + 1];
    printInstructions();
    
    generatePassword(password);
    printf("Generated Secure Password: %s\n", password);
    
    return 0;
}