//GEMINI-pro DATASET v1.0 Category: Personal Finance Planner ; Style: careful
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of transactions
#define MAX_TRANSACTIONS 100

// Define the transaction types
#define INCOME 1
#define EXPENSE 2

// Define the categories
#define FOOD 1
#define HOUSING 2
#define TRANSPORTATION 3
#define ENTERTAINMENT 4
#define OTHER 5

// Define the transaction structure
typedef struct {
  int type;
  int category;
  double amount;
} transaction;

// Function to add a transaction
void add_transaction(transaction* transactions, int* num_transactions, int type, int category, double amount) {
  // Check if the number of transactions has reached the maximum
  if (*num_transactions == MAX_TRANSACTIONS) {
    printf("Error: Maximum number of transactions reached.\n");
    return;
  }

  // Add the transaction to the array
  transactions[*num_transactions].type = type;
  transactions[*num_transactions].category = category;
  transactions[*num_transactions].amount = amount;

  // Increment the number of transactions
  (*num_transactions)++;
}

// Function to print the transactions
void print_transactions(transaction* transactions, int num_transactions) {
  // Print the header
  printf("Transactions:\n");
  printf("----------------------------------------------------------------------------------------------------\n");
  printf("Type | Category | Amount\n");
  printf("----------------------------------------------------------------------------------------------------\n");

  // Print each transaction
  for (int i = 0; i < num_transactions; i++) {
    printf("%s | %s | $%.2f\n", transactions[i].type == INCOME ? "Income" : "Expense", transactions[i].category == FOOD ? "Food" : transactions[i].category == HOUSING ? "Housing" : transactions[i].category == TRANSPORTATION ? "Transportation" : transactions[i].category == ENTERTAINMENT ? "Entertainment" : "Other", transactions[i].amount);
  }

  // Print the footer
  printf("----------------------------------------------------------------------------------------------------\n");
}

// Function to calculate the total income
double calculate_total_income(transaction* transactions, int num_transactions) {
  // Initialize the total income
  double total_income = 0;

  // Calculate the total income
  for (int i = 0; i < num_transactions; i++) {
    if (transactions[i].type == INCOME) {
      total_income += transactions[i].amount;
    }
  }

  // Return the total income
  return total_income;
}

// Function to calculate the total expense
double calculate_total_expense(transaction* transactions, int num_transactions) {
  // Initialize the total expense
  double total_expense = 0;

  // Calculate the total expense
  for (int i = 0; i < num_transactions; i++) {
    if (transactions[i].type == EXPENSE) {
      total_expense += transactions[i].amount;
    }
  }

  // Return the total expense
  return total_expense;
}

// Function to calculate the net income
double calculate_net_income(double total_income, double total_expense) {
  // Calculate the net income
  double net_income = total_income - total_expense;

  // Return the net income
  return net_income;
}

// Function to print the report
void print_report(double total_income, double total_expense, double net_income) {
  // Print the header
  printf("Report:\n");
  printf("----------------------------------------------------------------------------------------------------\n");
  printf("Total Income | Total Expense | Net Income\n");
  printf("----------------------------------------------------------------------------------------------------\n");

  // Print the report
  printf("$%.2f | $%.2f | $%.2f\n", total_income, total_expense, net_income);

  // Print the footer
  printf("----------------------------------------------------------------------------------------------------\n");
}

// Main function
int main() {
  // Initialize the transactions array
  transaction transactions[MAX_TRANSACTIONS];

  // Initialize the number of transactions
  int num_transactions = 0;

  // Add some transactions
  add_transaction(transactions, &num_transactions, INCOME, FOOD, 100);
  add_transaction(transactions, &num_transactions, EXPENSE, HOUSING, 200);
  add_transaction(transactions, &num_transactions, INCOME, TRANSPORTATION, 150);
  add_transaction(transactions, &num_transactions, EXPENSE, ENTERTAINMENT, 50);
  add_transaction(transactions, &num_transactions, INCOME, OTHER, 100);
  add_transaction(transactions, &num_transactions, EXPENSE, OTHER, 50);

  // Print the transactions
  print_transactions(transactions, num_transactions);

  // Calculate the total income
  double total_income = calculate_total_income(transactions, num_transactions);

  // Calculate the total expense
  double total_expense = calculate_total_expense(transactions, num_transactions);

  // Calculate the net income
  double net_income = calculate_net_income(total_income, total_expense);

  // Print the report
  print_report(total_income, total_expense, net_income);

  return 0;
}