//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int voter_id;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates++].votes = 0;
}

void add_voter(char* name, int voter_id) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    strcpy(voters[num_voters].name, name);
    voters[num_voters++].voter_id = voter_id;
}

void vote(int voter_id, int candidate_index) {
    for (int i = 0; i < num_voters; i++) {
        if (voters[i].voter_id == voter_id) {
            printf("Voter %s has already voted.\n", voters[i].name);
            return;
        }
    }

    for (int i = 0; i < num_candidates; i++) {
        if (i == candidate_index) {
            candidates[i].votes++;
            printf("Vote counted for %s.\n", candidates[i].name);
            break;
        }
    }
}

void display_results() {
    printf("\nElection Results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%d. %s - %d votes\n", i+1, candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("John Doe");
    add_candidate("Jane Smith");

    add_voter("Alice", 1);
    add_voter("Bob", 2);

    vote(1, 0);
    vote(2, 1);

    display_results();

    return 0;
}