//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: relaxed
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define MAX_URL_LEN 256

void sanitize_url(char *url)
{
    char *ptr = url;
    char *start = NULL;
    char *end = NULL;
    int len = 0;

    // Normalize the URL
    while (*ptr)
    {
        if (isalnum(*ptr) || *ptr == '-' || *ptr == '_')
        {
            if (!start)
            {
                start = ptr;
            }
            end = ptr;
        }
        else if (*ptr == '/' || *ptr == '?')
        {
            if (start)
            {
                len = end - start + 1;
                memcpy(start, ptr, len);
                start = NULL;
            }
        }
        ptr++;
    }

    // Remove extra slashes
    if (start && end)
    {
        len = end - start + 1;
        memcpy(start, end, len);
    }

    // Null terminate the URL
    *end = '\0';
}

int main()
{
    char url[MAX_URL_LEN] = "This is a sample URL with lots of special characters!/";
    sanitize_url(url);
    printf("%s", url);
    return 0;
}