//Falcon2-11B DATASET v1.0 Category: Tic Tac Toe AI ; Style: irregular
#include <stdio.h>
#include <stdlib.h>

// Function to print the board
void printBoard(int board[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }
}

// Function to check if the board is full
int isBoardFull(int board[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            if (board[i][j] == 0) {
                return 0;
            }
        }
    }
    return 1;
}

// Function to check if there is a winner
int isWinner(int board[3][3], int player) {
    if (board[0][0] == player && board[0][1] == player && board[0][2] == player) {
        return 1;
    } else if (board[1][0] == player && board[1][1] == player && board[1][2] == player) {
        return 1;
    } else if (board[2][0] == player && board[2][1] == player && board[2][2] == player) {
        return 1;
    } else if (board[0][0] == player && board[1][0] == player && board[2][0] == player) {
        return 1;
    } else if (board[0][1] == player && board[1][1] == player && board[2][1] == player) {
        return 1;
    } else if (board[0][2] == player && board[1][2] == player && board[2][2] == player) {
        return 1;
    } else if (board[0][0] == player && board[1][1] == player && board[2][2] == player) {
        return 1;
    } else if (board[2][0] == player && board[1][1] == player && board[0][2] == player) {
        return 1;
    }
    return 0;
}

// Function to check if the board is empty
int isBoardEmpty(int board[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            if (board[i][j]!= 0) {
                return 0;
            }
        }
    }
    return 1;
}

// Function to check if the board is full or if there is a winner
int isGameOver(int board[3][3]) {
    if (isBoardFull(board)) {
        return 1;
    } else if (isWinner(board, 1)) {
        return 1;
    } else if (isWinner(board, 2)) {
        return 1;
    } else if (isBoardEmpty(board)) {
        return 1;
    }
    return 0;
}

// Function to get the next move
int getNextMove(int board[3][3], int player) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            if (board[i][j] == 0) {
                board[i][j] = player;
                if (isGameOver(board)) {
                    return i;
                }
                board[i][j] = 0;
            }
        }
    }
    return -1;
}

// Function to play the game
int playGame(int board[3][3]) {
    int player = 1;
    int move = 0;
    while (1) {
        if (isGameOver(board)) {
            if (move == 0) {
                printf("Player 1 wins!\n");
            } else if (move == 1) {
                printf("Player 2 wins!\n");
            } else {
                printf("It's a tie!\n");
            }
            return 0;
        }
        move = getNextMove(board, player);
        if (move == -1) {
            printf("It's a tie!\n");
            return 0;
        }
        board[move][0] = player;
        if (player == 1) {
            player = 2;
        } else {
            player = 1;
        }
        printBoard(board);
    }
    return 0;
}

int main() {
    int board[3][3] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    playGame(board);
    return 0;
}