//GPT-4o-mini DATASET v1.0 Category: Bitwise operations ; Style: Claude Shannon
#include <stdio.h>
#include <stdbool.h>

#define BITS 32

// Function to display the bits of an integer
void displayBits(unsigned int num) {
    for (int i = BITS - 1; i >= 0; i--) {
        printf("%d", (num >> i) & 1);
    }
    printf("\n");
}

// Function to perform bitwise AND on two integers
unsigned int bitwiseAnd(unsigned int a, unsigned int b) {
    return a & b;
}

// Function to perform bitwise OR on two integers
unsigned int bitwiseOr(unsigned int a, unsigned int b) {
    return a | b;
}

// Function to perform bitwise XOR on two integers
unsigned int bitwiseXor(unsigned int a, unsigned int b) {
    return a ^ b;
}

// Function to perform bitwise NOT on an integer
unsigned int bitwiseNot(unsigned int a) {
    return ~a;
}

// Function to perform left shift operation
unsigned int leftShift(unsigned int a, int shift) {
    return a << shift;
}

// Function to perform right shift operation
unsigned int rightShift(unsigned int a, int shift) {
    return a >> shift;
}

// Function to demonstrate bitwise operations
void bitwiseOperationsDemo() {
    unsigned int a = 12; // 00000000000000000000000000001100
    unsigned int b = 10; // 00000000000000000000000000001010

    printf("Initial Values:\n");
    printf("a = %u, b = %u\n", a, b);
    
    printf("\nBinary Representation:\n");
    printf("a = ");
    displayBits(a);
    printf("b = ");
    displayBits(b);
    
    printf("\nBitwise AND:\n");
    unsigned int andResult = bitwiseAnd(a, b);
    printf("a & b = %u\n", andResult);
    displayBits(andResult);
    
    printf("\nBitwise OR:\n");
    unsigned int orResult = bitwiseOr(a, b);
    printf("a | b = %u\n", orResult);
    displayBits(orResult);
    
    printf("\nBitwise XOR:\n");
    unsigned int xorResult = bitwiseXor(a, b);
    printf("a ^ b = %u\n", xorResult);
    displayBits(xorResult);
    
    printf("\nBitwise NOT:\n");
    unsigned int notResult = bitwiseNot(a);
    printf("~a = %u\n", notResult);
    displayBits(notResult);
    
    printf("\nLeft Shift:\n");
    unsigned int leftShiftResult = leftShift(a, 2);
    printf("a << 2 = %u\n", leftShiftResult);
    displayBits(leftShiftResult);
    
    printf("\nRight Shift:\n");
    unsigned int rightShiftResult = rightShift(a, 2);
    printf("a >> 2 = %u\n", rightShiftResult);
    displayBits(rightShiftResult);

    printf("\nDemonstrating Various Combinations:\n");
    unsigned int combinedResult = (andResult | xorResult) & leftShiftResult;
    printf("Combined result ((a & b) | (a ^ b)) & (a << 2) = %u\n", combinedResult);
    displayBits(combinedResult);
}

// Main function
int main() {
    printf("Bitwise Operations Demo\n");
    printf("========================\n");
    bitwiseOperationsDemo();
    return 0;
}