//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

// Constants for weather simulation
#define NUM_WEATHER_TYPES 4
#define DAYS 7

// Enum for different weather types
typedef enum {
    SUNNY,
    RAINY,
    CLOUDY,
    WINDY
} WeatherType;

// Function prototypes
void displayWeather(WeatherType weather, int day);
WeatherType generateWeather();
void simulateWeekWeather();

int main() {
    printf("Welcome to the Peaceful Weather Simulation!\n");
    printf("We will simulate the weather for the next %d days.\n\n", DAYS);

    simulateWeekWeather();

    printf("\nThank you for experiencing this peaceful weather simulation!\n");
    return 0;
}

void simulateWeekWeather() {
    WeatherType weekWeather[DAYS];

    // Seed random number generator
    srand(time(0));

    // Generate a week of weather
    for (int day = 0; day < DAYS; day++) {
        weekWeather[day] = generateWeather();
        displayWeather(weekWeather[day], day + 1);
    }
}

WeatherType generateWeather() {
    return (WeatherType)(rand() % NUM_WEATHER_TYPES);
}

void displayWeather(WeatherType weather, int day) {
    const char *weatherDescriptions[NUM_WEATHER_TYPES] = {
        "A beautiful sunny day, perfect for a walk in the park!",
        "A rainy day, enjoy the soothing sound of rain on your window.",
        "A cloudy day, a cozy ambiance to read a book or sip tea indoors.",
        "A windy day, feel the refreshing breeze as you take a stroll."
    };
    
    printf("Day %d: %s\n", day, weatherDescriptions[weather]);
}