//GEMINI-pro DATASET v1.0 Category: Arithmetic ; Style: future-proof
#include <stdio.h>
#include <stdint.h>
#include <inttypes.h>
#include <stdbool.h>

// Define a custom data type for complex numbers
typedef struct {
    double real;
    double imaginary;
} complex_t;

// Function to add two complex numbers
complex_t complex_add(complex_t a, complex_t b) {
    complex_t result;
    result.real = a.real + b.real;
    result.imaginary = a.imaginary + b.imaginary;
    return result;
}

// Function to subtract two complex numbers
complex_t complex_subtract(complex_t a, complex_t b) {
    complex_t result;
    result.real = a.real - b.real;
    result.imaginary = a.imaginary - b.imaginary;
    return result;
}

// Function to multiply two complex numbers
complex_t complex_multiply(complex_t a, complex_t b) {
    complex_t result;
    result.real = (a.real * b.real) - (a.imaginary * b.imaginary);
    result.imaginary = (a.real * b.imaginary) + (a.imaginary * b.real);
    return result;
}

// Function to divide two complex numbers
complex_t complex_divide(complex_t a, complex_t b) {
    complex_t result;
    double denominator = (b.real * b.real) + (b.imaginary * b.imaginary);
    result.real = ((a.real * b.real) + (a.imaginary * b.imaginary)) / denominator;
    result.imaginary = ((a.imaginary * b.real) - (a.real * b.imaginary)) / denominator;
    return result;
}

// Function to print a complex number
void complex_print(complex_t c) {
    printf("(%.2f, %.2f)\n", c.real, c.imaginary);
}

int main() {
    // Create two complex numbers
    complex_t a = {1.0, 2.0}, b = {3.0, 4.0};

    // Add the two complex numbers
    complex_t c = complex_add(a, b);

    // Subtract the two complex numbers
    complex_t d = complex_subtract(a, b);

    // Multiply the two complex numbers
    complex_t e = complex_multiply(a, b);

    // Divide the two complex numbers
    complex_t f = complex_divide(a, b);

    // Print the results
    printf("a = ");
    complex_print(a);
    printf("b = ");
    complex_print(b);
    printf("c = a + b = ");
    complex_print(c);
    printf("d = a - b = ");
    complex_print(d);
    printf("e = a * b = ");
    complex_print(e);
    printf("f = a / b = ");
    complex_print(f);

    return 0;
}