//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: irregular
#include <stdio.h>
#include <stdlib.h>

// Define a structure for the database
typedef struct {
    char name[50];
    int age;
    float salary;
} Employee;

// Function to add an employee to the database
void addEmployee(Employee* db, int size, int count, char* name, int age, float salary) {
    if (count >= size) {
        printf("Database is full. Cannot add more employees.\n");
        return;
    }

    strcpy(db[count].name, name);
    db[count].age = age;
    db[count].salary = salary;
    count++;
}

// Function to display all employees in the database
void displayEmployees(Employee* db, int size, int count) {
    printf("Employees in the database:\n");
    for (int i = 0; i < count; i++) {
        printf("%s - Age: %d - Salary: %.2f\n", db[i].name, db[i].age, db[i].salary);
    }
}

// Function to search for an employee by name
int searchEmployee(Employee* db, int size, int count, char* name) {
    for (int i = 0; i < count; i++) {
        if (strcmp(db[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

// Function to update an employee's information
void updateEmployee(Employee* db, int size, int count, int index, char* name, int age, float salary) {
    if (index >= count || index < 0) {
        printf("Invalid index.\n");
        return;
    }

    strcpy(db[index].name, name);
    db[index].age = age;
    db[index].salary = salary;
}

// Function to delete an employee from the database
void deleteEmployee(Employee* db, int size, int count, int index) {
    if (index >= count || index < 0) {
        printf("Invalid index.\n");
        return;
    }

    for (int i = index; i < count - 1; i++) {
        db[i] = db[i + 1];
    }
    count--;
}

int main() {
    Employee db[100];
    int size = 100;
    int count = 0;

    // Add some employees
    addEmployee(db, size, count, "John Doe", 30, 50000);
    addEmployee(db, size, count, "Jane Smith", 28, 60000);
    addEmployee(db, size, count, "Alice Johnson", 25, 70000);

    // Display all employees
    displayEmployees(db, size, count);

    // Search for an employee
    int index = searchEmployee(db, size, count, "Jane Smith");
    if (index!= -1) {
        printf("Found employee at index %d.\n", index);
    } else {
        printf("Employee not found.\n");
    }

    // Update an employee's information
    updateEmployee(db, size, count, 1, "John Updated", 31, 55000);

    // Display all employees again
    displayEmployees(db, size, count);

    // Delete an employee
    deleteEmployee(db, size, count, 2);

    // Display all employees again
    displayEmployees(db, size, count);

    return 0;
}