//Falcon-180B DATASET v1.0 Category: Recursive ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_LENGTH 1000

void paranoid_string_copy(char *dest, const char *src) {
    if (src == NULL || dest == NULL) {
        printf("Error: NULL pointer detected!\n");
        exit(1);
    }

    int len = strlen(src);
    if (len >= MAX_LENGTH) {
        printf("Error: String too long!\n");
        exit(1);
    }

    strcpy(dest, src);
}

void paranoid_string_concat(char *dest, const char *src1, const char *src2) {
    if (src1 == NULL || src2 == NULL || dest == NULL) {
        printf("Error: NULL pointer detected!\n");
        exit(1);
    }

    int len1 = strlen(src1);
    int len2 = strlen(src2);
    int total_len = len1 + len2;

    if (total_len >= MAX_LENGTH) {
        printf("Error: String too long!\n");
        exit(1);
    }

    strcpy(dest, src1);
    strcat(dest, src2);
}

void paranoid_string_compare(const char *str1, const char *str2) {
    if (str1 == NULL || str2 == NULL) {
        printf("Error: NULL pointer detected!\n");
        exit(1);
    }

    int result = strcmp(str1, str2);

    if (result == 0) {
        printf("The strings are equal.\n");
    } else if (result < 0) {
        printf("String 1 is less than string 2.\n");
    } else {
        printf("String 1 is greater than string 2.\n");
    }
}

int main() {
    char str1[MAX_LENGTH] = "Hello, world!";
    char str2[MAX_LENGTH] = "This is a test.";

    paranoid_string_copy(str1, "Hello, world!");
    paranoid_string_copy(str2, "This is a test.");

    paranoid_string_concat(str1, str1, str2);

    paranoid_string_compare(str1, str2);

    return 0;
}