//Falcon-180B DATASET v1.0 Category: Fibonacci Sequence Visualizer ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define MAX_TERMS 1000000

int main() {
    int terms = 0;
    int n1 = 1, n2 = 1, n3;
    double golden_ratio = 1.61803398875;
    double x_offset, y_offset;
    double x1, y1, x2, y2;
    double x3, y3;
    char input;

    srand(time(NULL));

    // Set up the window
    x_offset = -2.0 / golden_ratio;
    y_offset = -1.0;

    printf("Fibonacci Sequence Visualizer\n");
    printf("Press any key to start...\n");
    getchar();

    while (terms < MAX_TERMS) {
        // Draw the first two terms
        x1 = x_offset;
        y1 = y_offset;
        x2 = x_offset + 1.0;
        y2 = y_offset;
        printf("%.2f,%.2f %.2f,%.2f\n", x1, y1, x2, y2);

        // Calculate the next term
        n3 = n1 + n2;
        if (n3 > MAX_TERMS) {
            break;
        }

        // Draw the next term
        x3 = x2 + 1.0;
        y3 = y2 + 1.0;
        printf("%.2f,%.2f %.2f,%.2f\n", x2, y2, x3, y3);

        // Update the current terms
        n1 = n2;
        n2 = n3;

        // Check for user input
        input = getchar();
        if (input == 'q' || input == 'Q') {
            break;
        }

        terms++;
    }

    return 0;
}