//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_CLIENT_LENGTH 1024
#define MAX_SERVER_LENGTH 2048

struct client_info {
    char name[MAX_CLIENT_LENGTH];
    char message[MAX_CLIENT_LENGTH];
};

struct server_info {
    char greeting[MAX_SERVER_LENGTH];
};

int main(int argc, char *argv[]) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(8080),
        .sin_addr.s_addr = inet_addr("127.0.0.1")
    };

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    char *message = "Hello, client!";
    send(sock, message, strlen(message), 0);

    char client_message[MAX_CLIENT_LENGTH];
    recv(sock, client_message, MAX_CLIENT_LENGTH, 0);
    printf("Server received message: %s\n", client_message);

    struct client_info client_info = {
        .name = "Alice",
        .message = "How are you?"
    };

    send(sock, &client_info, sizeof(client_info), 0);

    char server_message[MAX_SERVER_LENGTH];
    recv(sock, server_message, MAX_SERVER_LENGTH, 0);
    printf("Server replied: %s\n", server_message);

    close(sock);

    return 0;
}

int send_message(int sock, char *message) {
    return send(sock, message, strlen(message), 0);
}

int recv_message(int sock, char *message, int max_length) {
    return recv(sock, message, max_length, 0);
}