//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Function declarations
static int callback(void *data, int argc, char **argv, char **azColName);
void create_table(sqlite3 *db);
void insert_book(sqlite3 *db, const char *title, const char *author);
void query_books(sqlite3 *db);
void delete_book(sqlite3 *db, int id);

int main() {
    sqlite3 *db;
    char *errMsg = 0;

    // Open the mystical library database
    if (sqlite3_open("library.db", &db)) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return(0);
    }

    // Create the Books table
    create_table(db);

    // Insert some enchanting books
    insert_book(db, "The Adventures of C Programming", "An Enthusiastic Coder");
    insert_book(db, "Mysteries of the SQLite", "Database Whisperer");
    insert_book(db, "Chasing Syntax Errors", "The Compiler Conqueror");

    // Query and display all books
    query_books(db);

    // A whimsical tale about deleting a book
    printf("Removing 'Chasing Syntax Errors' from our library...\n");
    delete_book(db, 3); // Assuming the book has ID 3

    // Show the remaining books in the library
    query_books(db);

    // Closing the enchanted library
    sqlite3_close(db);
    return 0;
}

// Callback function for SQLite
static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s: %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Create Books table
void create_table(sqlite3 *db) {
    char *errMsg = 0;
    const char *sql = "CREATE TABLE IF NOT EXISTS BOOKS(" \
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT," \
                      "TITLE TEXT NOT NULL," \
                      "AUTHOR TEXT NOT NULL);";

    if (sqlite3_exec(db, sql, 0, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully.\n");
    }
}

// Insert a book into the database
void insert_book(sqlite3 *db, const char *title, const char *author) {
    char *errMsg = 0;
    char sql[256];
    snprintf(sql, sizeof(sql), "INSERT INTO BOOKS (TITLE, AUTHOR) VALUES ('%s', '%s');", title, author);

    if (sqlite3_exec(db, sql, 0, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Inserted book: '%s' by '%s'.\n", title, author);
    }
}

// Query books and display them
void query_books(sqlite3 *db) {
    const char *sql = "SELECT * FROM BOOKS;";
    char *errMsg = 0;

    printf("Querying all books in the library...\n");
    if (sqlite3_exec(db, sql, callback, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

// Delete a book by ID
void delete_book(sqlite3 *db, int id) {
    char *errMsg = 0;
    char sql[256];
    snprintf(sql, sizeof(sql), "DELETE FROM BOOKS WHERE ID = %d;", id);

    if (sqlite3_exec(db, sql, 0, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Book with ID %d deleted successfully.\n", id);
    }
}