//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: calm
#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_SNAPLEN 65535
#define MAX_PCAP_FILE "pcap_file.pcap"

typedef struct {
    u_char *data;
    size_t size;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet *pkt = (Packet *)args;
    pkt->data = (u_char *)malloc(header->len);
    pkt->size = header->len;
    memcpy(pkt->data, packet, header->len);
}

int main(int argc, char *argv[]) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char filter_expr[100] = "tcp or udp";
    struct bpf_program filter;
    char device[100] = "eth0";

    handle = pcap_open_live(device, MAX_SNAPLEN, 1, 0, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening device: %s\n", errbuf);
        exit(1);
    }

    if (pcap_compile(handle, &filter, filter_expr, 0, PCAP_NETMASK_UNKNOWN)!= 0) {
        fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    if (pcap_setfilter(handle, &filter)!= 0) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    Packet packet;
    packet.data = NULL;
    packet.size = 0;

    pcap_loop(handle, -1, process_packet, (u_char *)&packet);

    pcap_close(handle);

    FILE *fp;
    fp = fopen(MAX_PCAP_FILE, "wb");

    if (fp == NULL) {
        printf("File could not be created\n");
        return 1;
    }

    fwrite(packet.data, packet.size, 1, fp);
    fclose(fp);

    printf("Packet captured and saved to file successfully.\n");
    return 0;
}