//Falcon-180B DATASET v1.0 Category: Error handling ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// define an error handling structure
typedef struct {
    char *message;
    int line_number;
} Error;

// function to print error message
void print_error(Error error) {
    printf("Error at line %d: %s\n", error.line_number, error.message);
}

// function to create an error
Error create_error(int line_number, char *message) {
    Error error = {
       .message = message,
       .line_number = line_number
    };
    return error;
}

// function to handle errors
void handle_error(Error error) {
    print_error(error);
    exit(1);
}

// function to check if a string is a valid integer
int is_valid_integer(char *string) {
    for (int i = 0; i < strlen(string); i++) {
        if (!isdigit(string[i])) {
            return 0;
        }
    }
    return 1;
}

// function to add two integers
int add_integers(int a, int b) {
    return a + b;
}

// main function
int main() {
    // initialize variables
    int a = 5;
    int b = 10;
    char *c = "hello";
    int d = 0;

    // check if string is a valid integer
    if (!is_valid_integer(c)) {
        handle_error(create_error(__LINE__, "Invalid integer"));
    }

    // add two integers
    int result = add_integers(a, b);

    // check if division by zero
    if (d == 0) {
        handle_error(create_error(__LINE__, "Division by zero"));
    }

    // print result
    printf("Result: %d\n", result);

    return 0;
}