//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: relaxed
// Warehouse Management System

#include <stdio.h>
#include <stdlib.h>

#define MAX_PRODUCTS 100

struct product {
    int id;
    char name[50];
    int quantity;
};

void add_product(struct product* products, int num_products, int id, char* name, int quantity) {
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            printf("Product with ID %d already exists.\n", id);
            return;
        }
    }
    products[num_products].id = id;
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    num_products++;
}

void remove_product(struct product* products, int num_products, int id) {
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            for (int j = i; j < num_products - 1; j++) {
                products[j] = products[j + 1];
            }
            num_products--;
            return;
        }
    }
    printf("Product with ID %d not found.\n", id);
}

void update_product(struct product* products, int num_products, int id, char* name, int quantity) {
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            strcpy(products[i].name, name);
            products[i].quantity = quantity;
            return;
        }
    }
    printf("Product with ID %d not found.\n", id);
}

void display_products(struct product* products, int num_products) {
    printf("Product ID\tProduct Name\tQuantity\n");
    for (int i = 0; i < num_products; i++) {
        printf("%d\t%s\t%d\n", products[i].id, products[i].name, products[i].quantity);
    }
}

int main() {
    struct product products[MAX_PRODUCTS];
    int num_products = 0;

    // Add products
    add_product(products, num_products, 1, "Apple", 100);
    add_product(products, num_products, 2, "Banana", 50);
    add_product(products, num_products, 3, "Cherry", 25);

    // Remove product
    remove_product(products, num_products, 2);

    // Update product
    update_product(products, num_products, 1, "Red Apple", 75);

    // Display products
    display_products(products, num_products);

    return 0;
}