//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void add_item(char *name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item list full.\n");
}

void print_items() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s: %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

void calculate_total(int *total) {
    *total = 0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            *total += items[i].quantity * items[i].price;
        }
    }
}

int main() {
    add_item("Coffee", 5, 2.50);
    add_item("Tea", 3, 1.25);
    add_item("Juice", 2, 1.50);

    print_items();

    int total = 0;
    calculate_total(&total);

    printf("Total: $%.2f\n", total);

    return 0;
}