//GEMINI-pro DATASET v1.0 Category: Digital Auction System ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_BIDS 10

typedef struct {
    char name[50];
    int price;
    int num_bids;
    int bids[MAX_BIDS];
} Item;

Item items[MAX_ITEMS];
int num_items = 0;

void add_item(char *name, int price) {
    strcpy(items[num_items].name, name);
    items[num_items].price = price;
    items[num_items].num_bids = 0;
    num_items++;
}

void add_bid(int item_index, int bid) {
    if (bid > items[item_index].price) {
        items[item_index].bids[items[item_index].num_bids] = bid;
        items[item_index].num_bids++;
        items[item_index].price = bid;
    }
}

void print_items() {
    for (int i = 0; i < num_items; i++) {
        printf("%s: $%d\n", items[i].name, items[i].price);
    }
}

int main() {
    add_item("Mona Lisa", 1000000);
    add_item("Starry Night", 800000);
    add_item("The Scream", 900000);

    add_bid(0, 1100000);
    add_bid(1, 850000);
    add_bid(2, 950000);

    print_items();

    return 0;
}