//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 5
#define HEIGHT 5

#define BALL_X 2
#define BALL_Y 2

#define PADDLE_X 1
#define PADDLE_Y 0

int main()
{
    system("clear");

    // Game loop flag
    int game_on = 1;

    // Game board
    char board[HEIGHT][WIDTH] = {{'.', '.', '.', '.', '.'},
                                {'.', 'O', '.', '.', '.'},
                                {'.', '.', 'O', '.', '.'},
                                {'.', '.', '.', 'O', '.'},
                                {'.', '.', '.', '.', '.'}};

    // Ball position
    int ball_x = BALL_X;
    int ball_y = BALL_Y;

    // Paddle position
    int paddle_x = PADDLE_X;
    int paddle_y = PADDLE_Y;

    // Timer
    int timer = 0;

    // Game over flag
    int game_over = 0;

    // Main game loop
    while (game_on && !game_over)
    {
        // Draw the game board
        for (int y = 0; y < HEIGHT; y++)
        {
            for (int x = 0; x < WIDTH; x++)
            {
                printf("%c ", board[y][x]);
            }
            printf("\n");
        }

        // Move the ball
        ball_x++;
        ball_y++;

        // Check if the ball has hit a wall
        if (ball_x >= WIDTH - 1 || ball_x <= 0)
        {
            ball_x = BALL_X;
        }
        if (ball_y >= HEIGHT - 1)
        {
            game_over = 1;
        }

        // Move the paddle
        if (ball_y >= paddle_y)
        {
            paddle_y++;
        }

        // Check if the paddle has hit the ball
        if (ball_x == paddle_x && ball_y == paddle_y)
        {
            ball_x = BALL_X;
            ball_y = BALL_Y;
        }

        // Sleep for a while
        timer++;
        if (timer % 50 == 0)
        {
            system("clear");
        }
    }

    // Game over message
    printf("Game over!\n");

    return 0;
}