//Falcon2-11B DATASET v1.0 Category: Building a FTP Client ; Style: lively
// Building a FTP Client
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

// Function prototypes
int create_socket(int domain, int type, int protocol);
int connect_to_server(const char* server_name, int port);
int send_data_to_server(int socket_fd, const char* data);
int receive_data_from_server(int socket_fd, char* buffer, int size);
void close_socket(int socket_fd);

int main() {
    int socket_fd, port;
    char server_name[] = "localhost";
    char buffer[256];

    // Create socket
    if (create_socket(AF_INET, SOCK_STREAM, 0) < 0) {
        printf("Error creating socket\n");
        return 1;
    }

    // Connect to server
    if (connect_to_server(server_name, 21) < 0) {
        printf("Error connecting to server\n");
        return 1;
    }

    // Send command
    if (send_data_to_server(socket_fd, "USER anonymous\r\n") < 0) {
        printf("Error sending command to server\n");
        return 1;
    }
    if (send_data_to_server(socket_fd, "PASS 123456\r\n") < 0) {
        printf("Error sending command to server\n");
        return 1;
    }

    // Receive directory listing
    if (receive_data_from_server(socket_fd, buffer, 256) < 0) {
        printf("Error receiving data from server\n");
        return 1;
    }

    // Close socket
    close_socket(socket_fd);

    return 0;
}

// Create socket function
int create_socket(int domain, int type, int protocol) {
    int socket_fd;

    socket_fd = socket(domain, type, protocol);
    if (socket_fd < 0) {
        perror("Error creating socket");
        return -1;
    }
    return socket_fd;
}

// Connect to server function
int connect_to_server(const char* server_name, int port) {
    struct sockaddr_in server_addr;
    int socket_fd;

    socket_fd = create_socket(AF_INET, SOCK_STREAM, 0);
    if (socket_fd < 0) {
        perror("Error creating socket");
        return -1;
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    server_addr.sin_addr.s_addr = inet_addr(server_name);

    if (connect(socket_fd, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        perror("Error connecting to server");
        close(socket_fd);
        return -1;
    }

    return socket_fd;
}

// Send data to server function
int send_data_to_server(int socket_fd, const char* data) {
    int bytes_sent;

    bytes_sent = send(socket_fd, data, strlen(data), 0);
    if (bytes_sent < 0) {
        perror("Error sending data to server");
        return -1;
    }

    return bytes_sent;
}

// Receive data from server function
int receive_data_from_server(int socket_fd, char* buffer, int size) {
    int bytes_received;

    bytes_received = recv(socket_fd, buffer, size, 0);
    if (bytes_received < 0) {
        perror("Error receiving data from server");
        return -1;
    }

    return bytes_received;
}

// Close socket function
void close_socket(int socket_fd) {
    close(socket_fd);
}