//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>

struct Activity {
    int start;
    int finish;
};

// Function to compare two activities according to their finish times
int activityCompare(const void *a, const void *b) {
    return ((struct Activity *)a)->finish - ((struct Activity *)b)->finish;
}

// Function that utilizes a greedy approach to select the maximum number of non-overlapping activities
void selectActivities(struct Activity activities[], int n) {
    // Sort activities based on their finish time
    qsort(activities, n, sizeof(struct Activity), activityCompare);

    printf("Selected activities:\n");
    
    // The first activity always gets selected
    int lastFinishedIndex = 0; 
    printf("Activity %d: Start = %d, Finish = %d\n", 
           lastFinishedIndex+1, 
           activities[lastFinishedIndex].start, 
           activities[lastFinishedIndex].finish);
    
    for (int i = 1; i < n; i++) {
        // If the start time of the current activity is greater than or equal to 
        // the finish time of the last selected activity, select it
        if (activities[i].start >= activities[lastFinishedIndex].finish) {
            printf("Activity %d: Start = %d, Finish = %d\n", 
                   i+1, 
                   activities[i].start, 
                   activities[i].finish);
            lastFinishedIndex = i; // Update the last finished index
        }
    }
}

// Driver program to test the above functions
int main() {
    struct Activity activities[] = {
        {0, 6},
        {5, 7},
        {1, 4},
        {3, 5},
        {5, 9},
        {8, 9}
    };
    
    int n = sizeof(activities) / sizeof(activities[0]);
    selectActivities(activities, n);
    
    return 0;
}