//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: genious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define PI 3.14159265358979323846

typedef struct {
    int steps;
    double distance;
    double speed;
    double calories;
    double heart_rate;
    time_t timestamp;
} FitnessData;

void print_fitness_data(FitnessData data) {
    printf("Steps: %d\n", data.steps);
    printf("Distance: %.2f km\n", data.distance);
    printf("Speed: %.2f km/h\n", data.speed);
    printf("Calories: %.2f kcal\n", data.calories);
    printf("Heart Rate: %.2f bpm\n", data.heart_rate);
    printf("Timestamp: %s\n\n", ctime(&data.timestamp));
}

void calculate_fitness_data(FitnessData *data, int steps, double distance, double speed, double calories, double heart_rate, time_t timestamp) {
    data->steps = steps;
    data->distance = distance;
    data->speed = speed;
    data->calories = calories;
    data->heart_rate = heart_rate;
    data->timestamp = timestamp;
}

int main() {
    FitnessData data;
    int steps = 0;
    double distance = 0.0;
    double speed = 0.0;
    double calories = 0.0;
    double heart_rate = 0.0;
    time_t timestamp;

    // Initialize fitness tracker
    time(&timestamp);

    // Example usage of fitness tracker
    steps = 1000;
    distance = 5.0;
    speed = 10.0;
    calories = 50.0;
    heart_rate = 120.0;

    calculate_fitness_data(&data, steps, distance, speed, calories, heart_rate, timestamp);

    print_fitness_data(data);

    return 0;
}