//MISTRAL-7B DATASET v1.0 Category: Huffman Coding Implementation ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct Node {
    char ch;
    int freq;
    struct Node *left, *right;
} Node;

void getFreq(char *str, int len, int *freq) {
    for (int i = 0; i < len; i++) {
        if (freq[str[i]]++)
            continue;
        freq[str[i]] = 1;
    }
}

int main() {
    char message[100] = "Roses are red, violets are blue, my love is like a tree, growing just for you.";
    int freq[128];
    int len = strlen(message);

    getFreq(message, len, freq);

    Node **heap = malloc(len * sizeof(Node *));
    for (int i = 0; i < len; i++) {
        if (!freq[i])
            continue;
        heap[i] = (Node *) malloc(sizeof(Node));
        heap[i]->ch = i;
        heap[i]->freq = freq[i];
        heap[i]->left = NULL;
        heap[i]->right = NULL;
    }

    for (int i = 0; i < len - 1; i++) {
        int min1 = i, min2 = i + 1;
        if (heap[min1]->freq > heap[min2]->freq)
            min1 = min2;
        if (heap[min1]->freq > heap[min2]->freq) {
            Node *temp = heap[min1];
            heap[min1] = heap[min2];
            heap[min2] = temp;
        }
        if (i != min1) {
            Node *tempLeft = heap[i];
            heap[i] = heap[min1];
            heap[min1] = tempLeft;
            Node *tempRight = heap[min1 + 1];
            heap[min1 + 1] = heap[min2];
            heap[min2] = tempRight;
            heap[min2] = tempLeft;
        }
    }

    Node *root = heap[len - 1];

    printf("The encoded message is:\n");
    for (int i = 0; i < len; i++) {
        Node *temp = root;
        for (int j = 0; j < message[i]; j++) {
            if (temp->left)
                temp = temp->left;
            else
                temp = temp->right;
        }
        printf("%c : %s\n", temp->ch, (temp->left ? "0" : "1"));
        root = temp;
    }

    free(heap);
    return 0;
}