//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define weather conditions and their associated probabilities
#define NUM_WEATHER 7
const char *weather_descriptions[NUM_WEATHER] = {
  "Sunny and warm",
  "Sunny and cool",
  "Rainy and gloomy",
  "Rainy and refreshing",
  "Snowy and crisp",
  "Snowy and blustery",
  "Foggy and mysterious"
};
const int weather_probabilities[NUM_WEATHER] = {
  50,  // Sunny and warm
  25,  // Sunny and cool
  20,  // Rainy and gloomy
  10,  // Rainy and refreshing
   5,  // Snowy and crisp
   3,  // Snowy and blustery
   2   // Foggy and mysterious
};

int main() {
  // Set up random number generator
  srand(time(NULL));

  // Define number of days to simulate
  int num_days = 10;

  // Print header
  printf("Weather simulation for %d days:\n", num_days);
  printf("----------------------------------\n");

  // Run simulation for each day
  for (int day = 1; day <= num_days; day++) {
    int total_probability = 0;
    int weather_index = 0;

    // Calculate random number between 0 and 100
    int random_number = rand() % 101;

    // Find weather condition with highest probability that matches or exceeds random number
    for (int i = 0; i < NUM_WEATHER; i++) {
      total_probability += weather_probabilities[i];
      if (random_number <= total_probability) {
        weather_index = i;
        break;
      }
    }

    // Print weather condition for current day
    printf("Day %d: %s\n", day, weather_descriptions[weather_index]);
  }

  return 0;
}