//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAGIC_NUMBER 42

void magic_squared(int n) {
    if (n < 0) {
        printf("Invalid input. Exiting...\n");
        return;
    }

    int magic_square[n * n];
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            magic_square[i * n + j] = i * j;
        }
    }

    int row_sum[n];
    for (int i = 0; i < n; i++) {
        row_sum[i] = 0;
        for (int j = 0; j < n; j++) {
            row_sum[i] += magic_square[i * n + j];
        }
    }

    int col_sum[n];
    for (int i = 0; i < n; i++) {
        col_sum[i] = 0;
        for (int j = 0; j < n; j++) {
            col_sum[i] += magic_square[j * n + i];
        }
    }

    int dia_sum = 0;
    for (int i = 0; i < n; i++) {
        dia_sum += magic_square[i * n + i];
    }

    if (dia_sum != n * (n - 1) / 2) {
        printf("Invalid magic square. Exiting...\n");
        return;
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            printf("%d ", magic_square[i * n + j]);
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));
    int n = 5;
    magic_squared(n);
    return 0;
}